<?php
require_once('source/dbconfig.php');
require_once('source/function.php');
session_start();

// Verify results session
if (!isset($_SESSION['exam_completed'])) {
    header("Location: welcome.php");
    exit();
}

$result = $_SESSION['exam_completed'];
$passed = $result['score'] >= 50; // Assuming 50% is passing score
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Results - BKMS-BLC CBT Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .result-card {
            max-width: 700px;
            margin: 2rem auto;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .result-header {
            background-color: <?= $passed ? '#28a745' : '#dc3545' ?>;
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        .score-display {
            font-size: 3.5rem;
            font-weight: bold;
            margin: 1rem 0;
        }
        .result-details {
            padding: 2rem;
            background-color: white;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 0.8rem 0;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: 600;
            color: #6c757d;
        }
        .progress {
            height: 10px;
            margin: 1.5rem 0;
        }
        .action-btns {
            margin-top: 2rem;
        }
        .badge-status {
            font-size: 1rem;
            padding: 0.5rem 1rem;
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="result-card">
            <div class="result-header">
                <h2><i class="bi bi-<?= $passed ? 'check-circle' : 'exclamation-circle' ?>"></i> Exam Completed</h2>
                <p class="mb-0"><?= htmlspecialchars($result['subject']) ?></p>
            </div>
            
            <div class="result-details">
                <div class="text-center mb-4">
                    <div class="score-display text-<?= $passed ? 'success' : 'danger' ?>">
                        <?= $result['score'] ?>%
                    </div>
                    <span class="badge badge-status bg-<?= $passed ? 'success' : 'danger' ?>">
                        <?= $passed ? 'PASSED' : 'NOT PASSED' ?>
                    </span>
                    
                    <div class="progress">
                        <div class="progress-bar bg-<?= $passed ? 'success' : 'danger' ?>" 
                             role="progressbar" 
                             style="width: <?= $result['score'] ?>%" 
                             aria-valuenow="<?= $result['score'] ?>" 
                             aria-valuemin="0" 
                             aria-valuemax="100"></div>
                    </div>
                </div>
                
                <div class="mb-4">
                    <div class="detail-row">
                        <span class="detail-label">Correct Answers:</span>
                        <span><?= $result['correct'] ?>/<?= $result['total'] ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Class:</span>
                        <span><?= htmlspecialchars($result['class']) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Term:</span>
                        <span><?= htmlspecialchars($result['term']) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Session:</span>
                        <span><?= htmlspecialchars($result['session']) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Date Completed:</span>
                        <span><?= date('F j, Y g:i A') ?></span>
                    </div>
                </div>
                
                <div class="text-center action-btns">
                    <a href="welcome.php" class="btn btn-primary">
                        <i class="bi bi-house-door"></i> Back to Dashboard
                    </a>
                    <a href="view_results.php" class="btn btn-outline-secondary ms-2">
                        <i class="bi bi-eye"></i> View Detailed Results
                    </a>
                    <?php if (!$passed): ?>
                        <a href="retake_exam.php" class="btn btn-warning ms-2">
                            <i class="bi bi-arrow-repeat"></i> Retake Exam
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php
// Clear the results session after displaying
unset($_SESSION['exam_completed']);
?>